/////////////////////////////////////////////////////
//	Blowfish DLL Version 1.37
//  Borland C++ builder 3 Wrapper Control Ver. 1.2
//  By Kwok Ho Yin  1998,1999
////////////////////////////////////////////////////

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>

#include "blowfish.h"
#include "BlowfishVCL.h"

#pragma package(smart_init)

//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TBlowfish *)
{
    new TBlowfish(NULL);
}
//---------------------------------------------------------------------------
__fastcall TBlowfish::TBlowfish(TComponent* Owner)
    : TComponent(Owner)
{
    BFGETVERSIONPROC    FunctionPtr;

    //default key
	BlowfishKey = "1234567890";

    //default setting
    CrcCheckerFlag = false;
    CompressFlag = false;
    ErrLogFlag = true;

    //load Blowfish DLL, read MS Help to find the search path
    DLLHandle = LoadLibrary("Blowfish.DLL");

    if(DLLHandle == NULL)
    {
        MessageBox(NULL, "Cannot load Blowfish.DLL !", "Error", MB_OK);
    }
    else
    {
        //get dll version
        FunctionPtr = (BFGETVERSIONPROC)GetProcAddress(DLLHandle, "BF_GetVersion");
        (*FunctionPtr)(&FMajor, &FMinor, &FExtra, &FSpecial);
    }
}
//---------------------------------------------------------------------------
__fastcall TBlowfish::~TBlowfish()
{
    //unload the DLL
    if(DLLHandle != NULL)
    {
        FreeLibrary(DLLHandle);
    }
}
//---------------------------------------------------------------------------
UINT TBlowfish::GetErrorCode(void)
{
    BFGETERRORCODEPROC  FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFGETERRORCODEPROC)GetProcAddress(DLLHandle, "BF_GetErrorCode");
	    return (*FunctionPtr)();
    }
    else
        return 0;
}
//---------------------------------------------------------------------------
BOOL TBlowfish::InitializeKey(void)
{
    BFSETBLOWFISHKEYPROC   FunctionPtr_1;
    BFINITIALIZEKEYPROC    FunctionPtr_2;

    if(DLLHandle == NULL)
        return FALSE;

    FunctionPtr_1 = (BFSETBLOWFISHKEYPROC)GetProcAddress(DLLHandle, "BF_SetBlowfishKey");
    FunctionPtr_2 = (BFINITIALIZEKEYPROC)GetProcAddress(DLLHandle, "BF_InitializeKey");

    (*FunctionPtr_1)(BlowfishKey.c_str());

    return (*FunctionPtr_2)();
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Auto_Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFSETBLOWFISHKEYPROC   FunctionPtr_1;
    BFAUTOENCIPHERPROC     FunctionPtr_2;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr_1 = (BFSETBLOWFISHKEYPROC)GetProcAddress(DLLHandle, "BF_SetBlowfishKey");
    FunctionPtr_2 = (BFAUTOENCIPHERPROC)GetProcAddress(DLLHandle, "BF_Auto_Encipher");

    //set key
    (*FunctionPtr_1)(BlowfishKey.c_str());

    //encryption
    return (*FunctionPtr_2)(SourcePtr, InSize, OutSize);
}
//----------------------------------------------------------------------------
BYTE* TBlowfish::Auto_Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFSETBLOWFISHKEYPROC   FunctionPtr_1;
    BFAUTODECIPHERPROC     FunctionPtr_2;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr_1 = (BFSETBLOWFISHKEYPROC)GetProcAddress(DLLHandle, "BF_SetBlowfishKey");
    FunctionPtr_2 = (BFAUTODECIPHERPROC)GetProcAddress(DLLHandle, "BF_Auto_Decipher");

    //set key
    (*FunctionPtr_1)(BlowfishKey.c_str());

    //decryption
    return (*FunctionPtr_2)(SourcePtr, InSize, OutSize);
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Auto_Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFSETBLOWFISHKEYPROC       FunctionPtr_1;
    BFAUTODECIPHERTEXTPROC     FunctionPtr_2;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr_1 = (BFSETBLOWFISHKEYPROC)GetProcAddress(DLLHandle, "BF_SetBlowfishKey");
    FunctionPtr_2 = (BFAUTODECIPHERTEXTPROC)GetProcAddress(DLLHandle, "BF_Auto_Decipher_Text");

    //set key
    (*FunctionPtr_1)(BlowfishKey.c_str());

    //decryption
    return (*FunctionPtr_2)(SourcePtr, InSize, OutSize);
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Encipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFENCIPHERPROC      FunctionPtr;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr = (BFENCIPHERPROC)GetProcAddress(DLLHandle, "BF_Encipher");

    //encryption
    return (*FunctionPtr)(SourcePtr, InSize, OutSize);
}
//----------------------------------------------------------------------------
BYTE* TBlowfish::Decipher(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFDECIPHERPROC      FunctionPtr;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr = (BFDECIPHERPROC)GetProcAddress(DLLHandle, "BF_Decipher");

    //decryption
    return (*FunctionPtr)(SourcePtr, InSize, OutSize);
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Decipher_Text(BYTE *SourcePtr, UINT InSize, UINT *OutSize)
{
    BFDECIPHERTEXTPROC  FunctionPtr;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr = (BFDECIPHERTEXTPROC)GetProcAddress(DLLHandle, "BF_Decipher_Text");

    //decryption
    return (*FunctionPtr)(SourcePtr, InSize, OutSize);
}
//---------------------------------------------------------------------------
void TBlowfish::Free_ResultBuffer(BYTE *Ptr)
{
    BFFREERESULTBUFFERPROC  FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFFREERESULTBUFFERPROC)GetProcAddress(DLLHandle, "BF_Free_ResultBuffer");
        (*FunctionPtr)(Ptr);
    }
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::CreateProcessBlock(void)
{
    BFCREATEPROCESSBLOCKPROC    FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFCREATEPROCESSBLOCKPROC)GetProcAddress(DLLHandle, "BF_CreateProcessBlock");
        return (*FunctionPtr)();
    }
    else
        return NULL;
}
//---------------------------------------------------------------------------
void TBlowfish::FreeProcessBlock(BYTE *ProcessBlockPtr)
{
    BFFREEPROCESSBLOCKPROC      FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFFREEPROCESSBLOCKPROC)GetProcAddress(DLLHandle, "BF_FreeProcessBlock");
        (*FunctionPtr)(ProcessBlockPtr);
    }
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Encipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *FirstSmallBlockPtr, BYTE *ProcessRecordPtr, char flag)
{
    BFENCIPHERSMALLBLOCKPROC    FunctionPtr;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr = (BFENCIPHERSMALLBLOCKPROC)GetProcAddress(DLLHandle, "BF_Encipher_SmallBlock");

    return (*FunctionPtr)(SourcePtr, InSize, OutSize, FirstSmallBlockPtr, ProcessRecordPtr, flag);
}
//---------------------------------------------------------------------------
BYTE* TBlowfish::Decipher_SmallBlock(BYTE *SourcePtr, UINT InSize, UINT *OutSize, BYTE *ProcessRecordPtr, char flag)
{
    BFDECIPHERSMALLBLOCKPROC    FunctionPtr;

    if(DLLHandle == NULL)
        return NULL;

    FunctionPtr = (BFDECIPHERSMALLBLOCKPROC)GetProcAddress(DLLHandle, "BF_Decipher_SmallBlock");

    //decryption
    return (*FunctionPtr)(SourcePtr, InSize, OutSize, ProcessRecordPtr, flag);
}
//---------------------------------------------------------------------------
BOOL TBlowfish::Encipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize)
{
    BFENCIPHERFILEPROC  FunctionPtr;

    if(DLLHandle == NULL)
        return FALSE;

    FunctionPtr = (BFENCIPHERFILEPROC)GetProcAddress(DLLHandle, "BF_Encipher_File");

    //encryption
    return (*FunctionPtr)(inputfilename, outputfilename, OutSize);
}
//---------------------------------------------------------------------------
BOOL TBlowfish::Decipher_File(const char *inputfilename, const char *outputfilename, DWORD *OutSize)
{
    BFDECIPHERFILEPROC  FunctionPtr;

    if(DLLHandle == NULL)
        return FALSE;

    FunctionPtr = (BFDECIPHERFILEPROC)GetProcAddress(DLLHandle, "BF_Decipher_File");

    //decryption
    return (*FunctionPtr)(inputfilename, outputfilename, OutSize);
}
//---------------------------------------------------------------------------
void TBlowfish::GetErrorString(char *String)
{
    BFGETERRORSTRINGPROC    FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFGETERRORSTRINGPROC)GetProcAddress(DLLHandle, "BF_GetErrorString");
        (*FunctionPtr)(String);
    }
}
//---------------------------------------------------------------------------
void TBlowfish::SetCallbackFunc(CALLBACKFUNCPTR Funcptr)
{
    BFSETCALLBACKFUNCPROC   FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFSETCALLBACKFUNCPROC)GetProcAddress(DLLHandle, "BF_SetCallbackFunc");
        (*FunctionPtr)(Funcptr);
    }
}
//---------------------------------------------------------------------------
unsigned int __fastcall TBlowfish::FWriteMajor(unsigned int Major)
{
    return FMajor;
}
//---------------------------------------------------------------------------
unsigned int __fastcall TBlowfish::FWriteMinor(unsigned int Minor)
{
    return FMinor;
}
//---------------------------------------------------------------------------
unsigned int __fastcall TBlowfish::FWriteExtra(unsigned int Extra)
{
    return FExtra;
}
//---------------------------------------------------------------------------
unsigned int __fastcall TBlowfish::FWriteSpecial(unsigned int Special)
{
    return FSpecial;
}
//---------------------------------------------------------------------------
bool __fastcall TBlowfish::FWriteCrc_Check(bool flag)
{
    BFSETCRCCHECKERPROC     FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFSETCRCCHECKERPROC)GetProcAddress(DLLHandle, "BF_SetCrcChecker");

        //CRC
        if(flag == true)
            (*FunctionPtr)(TRUE);
        else
            (*FunctionPtr)(FALSE);
    }

    CrcCheckerFlag = flag;

    return flag;
}
//---------------------------------------------------------------------------
bool __fastcall TBlowfish::FWriteCompression(bool flag)
{
    BFSETCOMPRESSIONPROC    FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFSETCOMPRESSIONPROC)GetProcAddress(DLLHandle, "BF_SetCompression");

        //data compression
        if(flag == true)
            (*FunctionPtr)(TRUE);
        else
            (*FunctionPtr)(FALSE);
    }

    CompressFlag = flag;

    return flag;
}
//---------------------------------------------------------------------------
bool __fastcall TBlowfish::FWriteErrorLogFile(bool flag)
{
    BFSETERRORLOGFILEPROC   FunctionPtr;

    if(DLLHandle != NULL)
    {
        FunctionPtr = (BFSETERRORLOGFILEPROC)GetProcAddress(DLLHandle, "BF_SetErrorLogFile");

        //error log file
        if(flag == true)
            (*FunctionPtr)(TRUE);
        else
            (*FunctionPtr)(FALSE);
    }

    ErrLogFlag = flag;

    return flag;
}
//---------------------------------------------------------------------------
namespace Blowfishvcl
{
    void __fastcall PACKAGE Register()
    {
        TComponentClass classes[1] = {__classid(TBlowfish)};
        RegisterComponents("Security", classes, 0);
    }
}
//---------------------------------------------------------------------------







